#pragma once

#include <yplatform/range.h>
#include <yplatform/zerocopy/segment.h>
#include <cstdint>
#include <boost/array.hpp>
#include <utility>

namespace ymod_webserver { namespace websocket {

typedef boost::array<uint8_t, 4> mask_t;
static const mask_t empty_mask = { { 0, 0, 0, 0 } };

template <
    typename Base,
    typename CharType = BOOST_DEDUCED_TYPENAME boost::iterator_value<Base>::type>
class unmask_iterator
    : public boost::iterator_adaptor<
          unmask_iterator<Base, CharType>,
          Base,
          CharType,
          boost::single_pass_traversal_tag,
          CharType>
{
    friend class boost::iterator_core_access;
    typedef boost::iterator_adaptor<
        unmask_iterator<Base, CharType>,
        Base,
        CharType,
        boost::single_pass_traversal_tag,
        CharType>
        super_t;

    typedef unmask_iterator<Base, CharType> this_t;
    typedef BOOST_DEDUCED_TYPENAME boost::iterator_value<Base>::type base_value_type;

    CharType dereference() const
    {
        auto result = static_cast<CharType>(
            *this->base_reference() ^ mask_[mask_index_ % mask_t::static_size]);
        return result;
    }

    bool equal(this_t const& rhs) const
    {
        return this->base_reference() == rhs.base_reference();
    }

    void increment()
    {
        ++this->base_reference();
        ++mask_index_;
    }

    mask_t mask_;
    uint64_t mask_index_{ 0 };

public:
    unmask_iterator() : super_t(), mask_()
    {
    }

    unmask_iterator(Base const& start, const mask_t& mask)
        : super_t(start), mask_(mask), mask_index_(0)
    {
    }

    template <typename T>
    unmask_iterator(T const& start, const mask_t& mask)
        : super_t(static_cast<Base>(start)), mask_(mask), mask_index_(0)
    {
    }
};

template <
    typename Base,
    typename CharType = BOOST_DEDUCED_TYPENAME boost::iterator_value<Base>::type>
class mask_iterator : public unmask_iterator<Base, CharType>
{
    typedef unmask_iterator<Base, CharType> super_t;

public:
    mask_iterator() : super_t()
    {
    }

    mask_iterator(Base const& start, const mask_t& mask) : super_t(start, mask)
    {
    }

    template <typename T>
    mask_iterator(T const& start, const mask_t& mask) : super_t(static_cast<Base>(start), mask)
    {
    }
};

struct payload
{
    typedef unmask_iterator<yplatform::zerocopy::segment::iterator> iterator;

    payload() = default;

    payload(yplatform::zerocopy::segment d, const mask_t& m) : data(std::move(d)), mask(m)
    {
    }

    yplatform::zerocopy::segment data;
    mask_t mask;

    iterator begin() const
    {
        return iterator(data.begin(), mask);
    }

    iterator end() const
    {
        return iterator(data.end(), mask);
    }
};

template <typename Range>
inline payload make_websocket_payload(const Range& seg, const mask_t& mask)
{
    return payload(seg, mask);
}

}}
