#pragma once

#include <vector>

namespace ymod_webserver::websocket::codes {

enum code
{
    // 0-999 Status codes in the range 0-999 are not used
    shutdown = 0,
    close_opcode_normal = 1000,
    close_opcode_go_away = 1001,
    close_opcode_proto_error = 1002,
    close_opcode_data_error = 1003,
    // close_opcode_data_large = 1004,
    close_opcode_no_code = 1005,
    close_opcode_aborted = 1006,
    close_opcode_utf8_error = 1007,
    close_opcode_policy_error = 1008,
    close_opcode_data_large = 1009,
    close_opcode_extensions = 1010,
    // 3000-3999 use in framework
    // 4000-4999 use in application
    retry_after = 4000,
    bad_request = 4400,
    unauthorized = 4401,
    forbidden = 4403,
    not_found = 4404,
    gone = 4410,
    too_many_requests = 4429,
    internal_server_error = 4500,
    service_unavailable = 4503,
};

inline const std::vector<code>& stat_codes()
{
    static const std::vector<code> codes{ shutdown,
                                          close_opcode_normal,
                                          close_opcode_go_away,
                                          close_opcode_proto_error,
                                          close_opcode_data_error,
                                          close_opcode_no_code,
                                          close_opcode_aborted,
                                          close_opcode_utf8_error,
                                          close_opcode_policy_error,
                                          close_opcode_data_large,
                                          close_opcode_extensions,
                                          retry_after,
                                          bad_request,
                                          unauthorized,
                                          forbidden,
                                          not_found,
                                          gone,
                                          too_many_requests,
                                          internal_server_error,
                                          service_unavailable };
    return codes;
}

}
