#pragma once

#include <ymod_webserver/methods/dispatcher.h>
#include <ymod_webserver/handler.h>
#include <ymod_webserver/uri.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/websocket.h>

namespace ymod_webserver {

struct default_handler : public handler
{
    typedef ::ymod_webserver::dispatcher<http::stream_ptr> default_http_dispatcher_type;
    typedef ::ymod_webserver::dispatcher<websocket::stream_ptr> default_websocket_dispatcher_type;

    default_handler()
        : http_dispatcher(
              [](http::stream_ptr s) -> string { return s->request()->url.make_full_path(); })
        , ws_dispatcher(
              [](websocket::stream_ptr s) -> string { return s->request()->url.make_full_path(); })
    {
    }

    void execute(request_ptr /**/, http::stream_ptr stream) noexcept
    {
        http_dispatcher(stream);
    }

    void execute_websocket(websocket::stream_ptr stream) noexcept
    {
        ws_dispatcher(stream);
    }

    void upgrade_to_websocket(request_ptr)
    {
        if (ws_dispatcher.empty())
            throw http_error(
                "handler", "Not Implemented", "websocket_upgrade method not implemented")
                << http_result_code(codes::not_implemented);
    }

    default_http_dispatcher_type http_dispatcher;
    default_websocket_dispatcher_type ws_dispatcher;
};

} // namespace ymod_webserver