#pragma once

#include <boost/enable_shared_from_this.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/unordered_map.hpp>
#include "starter.h"
#include "module_stats.h"
#include <ymod_webserver/settings.h>
#include <yplatform/task_context.h>
#include <yplatform/net/server.h>

namespace ymod_webserver {

class starter;
struct request;
class http_stream;

namespace websocket {
class websocket_stream;
}

typedef boost::shared_ptr<session> session_ptr;
typedef boost::weak_ptr<session> session_weak_ptr;

class net_server : public iabstract
{
public:
    virtual void on_destroy(starter* starter, const process_result& result) = 0;
    virtual void on_destroy(http_stream* stream) = 0;
    virtual void on_destroy(net_session* session) = 0;
    virtual void on_destroy(request* request) = 0;
    virtual void on_destroy(websocket::websocket_stream* stream) = 0;
};

// TODO detect if response&recv object is destroyed but request is not

class yplatform_net_server
    : public net_server
    , public boost::enable_shared_from_this<yplatform_net_server>
    , public yplatform::log::contains_logger
{
public:
    yplatform_net_server(
        yplatform::net::io_data& io,
        std::shared_ptr<settings> st,
        std::shared_ptr<module_stats> stats)
        : io_(io), settings_(st), stats_(stats)
    {
    }

    void register_session(session_ptr);

    void on_session_ready(net_session_ptr session);

    void execute_http(starter* starter, request_ptr request, read_buffer_ptr read_buffer);

    void execute_websocket(starter* starter, request_ptr request, read_buffer_ptr read_buffer);

    void on_destroy(starter* starter, const process_result& result);
    void on_destroy(http_stream* stream);
    void on_destroy(net_session* session);
    void on_destroy(request* req);
    void on_destroy(websocket::websocket_stream* stream);

    const std::shared_ptr<module_stats> get_stats() const
    {
        return stats_;
    }

    //  void execute_websocket(request_ptr, );
    //  void handle_ssl_enabled(boost::shared_ptr<starter> starter, );
protected:
    boost::weak_ptr<yplatform_net_server> weak_from_this()
    {
        return shared_from_this();
    }
    void core_register_session(session_ptr session);

    boost::shared_ptr<http_stream> make_http_stream(
        session_ptr session,
        request_ptr request,
        read_buffer_ptr read_buffer);
    boost::shared_ptr<websocket::websocket_stream> make_websocket_stream(
        session_ptr session,
        request_ptr request,
        read_buffer_ptr read_buffer);

    session_ptr cast_session(net_session_ptr netsession);
    session* cast_session(net_session* netsession);
    void set_request_id(request& req);
    bool set_request_timeout(request& req);

    void accumulate_session_stats(net_session* netsession);
    void accumulate_http_timing_stats(http_stream* stream);
    void accumulate_websocket_timing_stats(websocket::websocket_stream* stream);

private:
    yplatform::net::io_data& io_;
    std::shared_ptr<settings> settings_;
    std::shared_ptr<module_stats> stats_;
};

typedef boost::shared_ptr<net_server> net_server_ptr;
typedef boost::weak_ptr<net_server> net_server_weak_ptr;

}
