#pragma once

#include <boost/bind/protect.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/thread/locks.hpp>
#include <yplatform/net/line_filter.h>
#include <yplatform/zerocopy/streambuf.h>
#include <yplatform/net/handlers/timer_handler.h>

#include <ymod_webserver/context.h>
#include <ymod_webserver/settings.h>
#include <ymod_webserver/handler.h>

namespace ymod_webserver {

typedef yplatform::zerocopy::streambuf read_buffer_t;
typedef boost::shared_ptr<yplatform::zerocopy::streambuf> read_buffer_ptr;
typedef read_buffer_t::mutable_buffers_type mutable_read_buffer_t;

struct session_stats
{
    size_t handshake_errors = 0;
    size_t read_errors = 0;
    size_t write_errors = 0;
    size_t ssl_errors = 0;
    string socket_info;
};

class net_session : public iabstract
{
public:
    typedef boost::function<void(boost::system::error_code const&, std::size_t)> read_hook_t;
    typedef boost::function<void(boost::system::error_code const&)> write_error_hook_t;
    typedef boost::function<void(boost::system::error_code const&)> close_hook_t;
    typedef boost::function<void()> shutdown_hook_t;
    typedef boost::function<void()> cancel_hook_t;

    //  yplatform::task_context_ptr get_context() const
    //  { return ctx_; }
    virtual context_ptr ctx() = 0;
    virtual const boost::asio::ip::address& remote_addr() const = 0;
    virtual unsigned short remote_port() const = 0;
    virtual const boost::asio::ip::address& local_addr() const = 0;
    virtual unsigned short local_port() const = 0;
    virtual const settings& session_settings() const = 0;
    virtual const ymod_webserver::endpoint& endpoint() const = 0;
    virtual const handler_ptr& handler() const = 0;
    virtual bool is_open() const = 0;
    virtual bool is_secure() const = 0;
    virtual void begin_read(
        read_hook_t const& hook,
        mutable_read_buffer_t buffer,
        std::size_t min) = 0;
    virtual void async_close(close_hook_t const& hook) = 0;
    virtual void do_shutdown(const shutdown_hook_t& hook, bool graceful) = 0;
    virtual void cancel_operations(const cancel_hook_t& hook) = 0;
    virtual boost::asio::io_service& current_io_service() = 0;
    virtual void send_client_stream(yplatform::net::buffers::const_chunk_buffer const&) = 0;
    virtual yplatform::net::streamer_wrapper client_stream() = 0;
    virtual void set_write_error_hook(write_error_hook_t const& write_error_hook) = 0;
    virtual unsigned requests_count() const = 0;
    virtual void increment_requests_count() = 0;
    virtual const session_stats& stats() = 0;
};

typedef boost::shared_ptr<net_session> net_session_ptr;

}
