#pragma once

#include <ymod_webserver/request.h>
#include "parser/header_value.h"
#include <yplatform/util.h>

namespace ymod_webserver { namespace parser {

template <typename Iterator>
void parse_content_type_value(content_description_base& v, Iterator b, Iterator e)
{
    Iterator i = b;
    while (i != e && *i != '/')
        ++i;
    v.type.assign(b, i);
    if (i == e) return;
    v.subtype.assign(++i, e);
}

class content_type_handler
{
    typedef string::const_iterator iter_t;

public:
    content_type_handler(content_description& part) : part_(part)
    {
    }

    void on_value(iter_t begin, iter_t end)
    {
        parse_content_type_value(part_, begin, end);
    }

    void on_param(iter_t nbegin, iter_t nend, iter_t vbegin, iter_t vend)
    {
        if (yplatform::util::iequals(boost::iterator_range<iter_t>(nbegin, nend), "boundary"))
            part_.boundary.assign(vbegin, vend);
    }

    void finished()
    {
    }

private:
    content_description& part_;
};

inline void parse_content_type(content_part& part)
{
    content_type_handler handler(part.content);
    header_map_t::const_iterator i_header = part.headers.find("content-type");
    if (i_header == part.headers.end()) return;
    parse_header_value(i_header->second.begin(), i_header->second.end(), handler);
}

}}
