#pragma once

#include "parser/header_value.h"

namespace ymod_webserver { namespace parser {

template <typename HeaderValue, typename ValueParser, typename Iterator>
class header_qvalue
{
    typedef Iterator iter_t;
    typedef typename HeaderValue::value_type subvalue_t;
    typedef header_qvalue<HeaderValue, ValueParser, Iterator> this_t;

public:
    header_qvalue(HeaderValue& result, const ValueParser& parser) : result_(result), parser_(parser)
    {
    }

    header_qvalue(const this_t& v) : result_(v.result_), parser_(v.parser_)
    {
    }

    void on_value(iter_t begin, iter_t end)
    {
        if (current_.get()) result_.insert(*current_.get());
        current_.reset(new subvalue_t);
        parser_(current_->value, begin, end);
    }
    void on_param(iter_t nbegin, iter_t nend, iter_t vbegin, iter_t vend)
    {
        if (!yplatform::util::iequals(boost::make_iterator_range(nbegin, nend), "q")) return;
        current_->qvalue = boost::lexical_cast<float>(boost::make_iterator_range(vbegin, vend));
    }
    void finished()
    {
        if (current_.get()) result_.insert(*current_.get());
    }

private:
    HeaderValue& result_;
    ValueParser parser_;
    std::unique_ptr<subvalue_t> current_;
};

template <typename Iterator>
void parse_string_header_value(string& v, Iterator b, Iterator e)
{
    v.assign(b, e);
}

template <typename Iterator, typename HeaderValue, typename ValueParser>
header_qvalue<HeaderValue, ValueParser, Iterator> make_header_qvalue(
    HeaderValue& result,
    const ValueParser& parser)
{
    return header_qvalue<HeaderValue, ValueParser, Iterator>(result, parser);
}

}}
