#pragma once

#include "parser/char_sets.h"

namespace ymod_webserver { namespace parser {

template <typename Iterator>
Iterator parse_header_value_skip_ws(Iterator begin, Iterator end)
{
    while (begin != end && symbols::is_whitespace(*begin))
        ++begin;
    return begin;
}

template <typename Handler, typename Iterator>
Iterator parse_header_value_param(Iterator begin, Iterator end, Handler& handler)
{
    Iterator i = begin;
    while (i != end && *i != ';' && *i != ',' && *i != '=')
        ++i;
    if (i == end)
    {
        handler.on_param(begin, i, end, end);
        return i;
    }
    if (*i == ';' || *i == ',')
    {
        handler.on_param(begin, i, end, end);
        return i;
    }
    Iterator i_val = i;
    Iterator i_val_end = ++i_val;
    bool quote_enabled = (i_val != end && *i_val == '"');
    if (quote_enabled) i_val_end = ++i_val;
    while (i_val_end != end && *i_val_end != ';' && *i_val_end != ',')
    {
        if (quote_enabled && *i_val_end == '"') break;
        ++i_val_end;
    }
    handler.on_param(begin, i, i_val, i_val_end);
    if (quote_enabled && i_val_end != end) ++i_val_end;
    return i_val_end;
}

template <typename Handler, typename Iterator>
Iterator parse_header_value_value(Iterator begin, Iterator end, Handler& handler)
{
    Iterator i = begin;
    while (i != end && *i != ';' && *i != ',')
        ++i;
    handler.on_value(begin, i);
    if (i == end) return i;
    if (*i == ',') return ++i;
    ++i;
    while ((i = parse_header_value_skip_ws(i, end)) != end)
    {
        i = parse_header_value_param(i, end, handler);
        if (i == end) break;
        if (*i == ',') return ++i;
        ++i;
    }
    return i;
}

template <typename Handler, typename Iterator>
void parse_header_value(Iterator begin, Iterator end, Handler& handler)
{
    do
    {
        begin = parse_header_value_value(begin, end, handler);
        if (begin == end) break;
    } while ((begin = parse_header_value_skip_ws(begin, end)) != end);
    handler.finished();
}

template <typename Handler, typename Iterator>
void parse_header_value_copy_handler(Iterator begin, Iterator end, const Handler& handler_)
{
    Handler handler = handler_;
    do
    {
        begin = parse_header_value_value(begin, end, handler);
        if (begin == end) break;
    } while ((begin = parse_header_value_skip_ws(begin, end)) != end);
    handler.finished();
}

}}
