#include "parser/request.h"
#include <boost/assign/list_of.hpp>
#include <boost/bimap.hpp>

namespace ymod_webserver { namespace parser {

namespace {
using bimap_type = boost::bimap<string, methods::http_method>;
const bimap_type string_2_method = boost::assign::list_of<bimap_type::relation>(
    "GET",
    methods::mth_get)("HEAD", methods::mth_head)("BMOVE", methods::mth_bmove)(
    "DELETE",
    methods::mth_delete)("CONNECT", methods::mth_connect)("CHECKOUT", methods::mth_checkout)(
    "POST",
    methods::mth_post)("PROPFIND", methods::mth_propfind)("PROPPATH", methods::mth_proppath)(
    "PUT",
    methods::mth_put)("TRACE", methods::mth_trace)("OPTIONS", methods::mth_options)(
    "REPORT",
    methods::mth_report)("MOVE", methods::mth_move)("MKACTIVITY", methods::mth_mkactivity)(
    "MKCOL",
    methods::mth_mkcol)("MERGE", methods::mth_merge);

}

methods::http_method get_method_by_name(const string& name)
{
    auto i_mth = string_2_method.left.find(name);
    if (i_mth == string_2_method.left.end()) return methods::mth_invalid;
    return i_mth->second;
}

const string& get_method_name(methods::http_method method)
{
    static const string EMPTY;
    auto i_mth = string_2_method.right.find(method);
    if (i_mth == string_2_method.right.end()) return EMPTY;
    return i_mth->second;
}

}}
