#pragma once

#include <yplatform/util.h>
#include <boost/range/iterator_range.hpp>
#include <ymod_webserver/request.h>

namespace ymod_webserver { namespace parser {

template <typename Iterator>
transfer_encoding_header parse_transfer_encoding(Iterator begin, Iterator end)
{
    boost::iterator_range<Iterator> range(begin, end);
    if (yplatform::util::iequals(range, "identity")) return transfer_encoding_identity;
    if (yplatform::util::iequals(range, "chunked")) return transfer_encoding_chunked;
    return transfer_encoding_ext;
}

template <typename Iterator>
te_encoding_header parse_te_encoding(Iterator begin, Iterator end)
{
    boost::iterator_range<Iterator> range(begin, end);
    if (yplatform::util::iequals(range, "gzip")) return te_encoding_gzip;
    if (yplatform::util::iequals(range, "compress")) return te_encoding_compress;
    if (yplatform::util::iequals(range, "deflate")) return te_encoding_deflate;
    return te_encoding_none;
}

template <typename Iterator>
content_encoding_header parse_content_encoding(Iterator begin, Iterator end)
{
    boost::iterator_range<Iterator> range(begin, end);
    if (yplatform::util::iequals(range, "identity")) return content_encoding_identity;
    if (yplatform::util::iequals(range, "gzip")) return content_encoding_gzip;
    if (yplatform::util::iequals(range, "compress")) return content_encoding_compress;
    if (yplatform::util::iequals(range, "deflate")) return content_encoding_deflate;
    if (yplatform::util::iequals(range, "*")) return content_encoding_all;
    return content_encoding_unknown;
}

template <typename Iterator>
connection_header parse_connection(Iterator begin, Iterator end)
{
    boost::iterator_range<Iterator> range(begin, end);
    if (yplatform::util::iequals(range, "close")) return connection_close;
    if (yplatform::util::iequals(range, "keep-alive")) return connection_keep_alive;
    if (yplatform::util::iequals(range, "upgrade")) return connection_upgrade;
    if (yplatform::util::iequals(range, "te")) return connection_keep_alive;
    return connection_close;
}

template <typename Iterator>
inline void parse_transfer_encoding_ref(transfer_encoding_header& v, Iterator begin, Iterator end)
{
    v = parse_transfer_encoding(begin, end);
}

template <typename Iterator>
inline void parse_te_encoding_ref(te_encoding_header& v, Iterator begin, Iterator end)
{
    v = parse_te_encoding(begin, end);
}

template <typename Iterator>
inline void parse_content_encoding_ref(content_encoding_header& v, Iterator begin, Iterator end)
{
    v = parse_content_encoding(begin, end);
}

template <typename Iterator>
inline void parse_connection_ref(connection_header& v, Iterator begin, Iterator end)
{
    v = parse_connection(begin, end);
}

}}
