#include "protect_url_params.h"

namespace ymod_webserver {

namespace {

void protect_param(string& url, const string& param)
{
    size_t pos = 0;
    auto pattern = param + '=';
    while (pos < url.size())
    {
        pos = url.find(pattern, pos);
        if (pos == string::npos) continue;
        if (pos == 0 || (url[pos - 1] != '&' && url[pos - 1] != '?'))
        {
            pos += pattern.size();
            continue;
        }
        auto value_beg = pos + pattern.size();
        auto value_end = url.find_first_of("&#", value_beg);
        value_end = value_end == string::npos ? url.size() : value_end;
        std::fill(url.begin() + value_beg, url.begin() + value_end, 'x');
        pos = value_end;
    }
}

}

void protect_url_params(string& url, const std::vector<string>& params)
{
    for (auto&& param : params)
    {
        protect_param(url, param);
    }
}

}
