#pragma once

#include "parser/request.h"
#include "transfer/parser.h"
#include <ymod_webserver/context.h>
#include <ymod_webserver/settings.h>
#include <ymod_webserver/receiver.h>
#include <yplatform/net/line_filter.h>
#include <yplatform/zerocopy/streambuf.h>
#include "session.h"

namespace ymod_webserver {

class net_server;

struct process_result
{
    enum state_t
    {
        inited,
        processing,
        failed,
        finished,
        continue_http,
        continue_websocket
    };

    state_t state;
    request_ptr request;
    read_buffer_ptr read_buffer;

    process_result() : state(state_t::inited)
    {
    }
};

/**
 * Detects connection fails only when reading.
 */
class starter
    : public boost::enable_shared_from_this<starter>
    , public yplatform::log::contains_logger

{
    typedef read_buffer_t buffer_t;
    typedef read_buffer_ptr buffer_ptr;
    typedef buffer_t::iterator read_iterator;
    typedef parser::request_parser<read_iterator> request_parser_t;
    typedef transfer::parser<buffer_t, read_iterator> transfer_parser_t;
    typedef yplatform::zerocopy::streambuf::mutable_buffers_type read_buffers_t;

public:
    starter(
        boost::asio::io_service& io,
        boost::weak_ptr<net_server> owner,
        net_session_ptr session,
        const settings& settings);
    ~starter();

    yplatform::task_context_ptr get_context() const
    {
        return ctx_;
    }

    context_ptr& ctx()
    {
        return ctx_;
    }

    //  boost::asio::io_service& io_service()
    //  { return *session_->get_io(); }

    net_session_ptr get_session()
    {
        return session_;
    }

    void run();

    void abort();

private:
    typedef void (starter::*parse_body_function)(std::size_t bytes);

    void init_context();
    void begin_new_request(const boost::system::error_code& e);
    void clear_data();
    bool check_request_line_or_headers_size();
    void begin_read_headers();
    void handle_read_headers(boost::system::error_code const& e, std::size_t bytes);

    void handle_write(boost::system::error_code const& e, std::size_t bytes);

    void start_read_body(parse_body_function parse_body, std::size_t min);
    void begin_read_body(parse_body_function parse_body, std::size_t min = 1);
    void handle_read_body(
        const boost::system::error_code& e,
        parse_body_function parse_body,
        std::size_t bytes);

    void parse_headers();
    void parse_body_mpost(std::size_t bytes);
    void parse_body_ws_message(std::size_t bytes);
    void parse_body_ws76_upgrade(std::size_t bytes);

    void begin_poll_connect();
    void handle_poll_connect(const boost::system::error_code& e);

    void begin_write_policy();

    void execute(bool expect_100_continue);
    void do_exec(const request_ptr& req);
    bool upgrade();

    buffer_ptr release_read_buffer()
    {
        buffer_ptr buf = readq_;
        readq_.reset();
        return buf;
    }

    response_ptr make_response();

    boost::weak_ptr<net_server> owner_;

    net_session_ptr session_;
    settings settings_;

    boost::asio::io_service* io_ = nullptr;
    buffer_ptr readq_;
    context_ptr ctx_;
    context_ptr session_ctx_;
    request_parser_t parser_;
    read_iterator i_saved_;
    request_body::read_mode post_mode_;
    std::unique_ptr<transfer_parser_t> transfer_parser_;
    process_result process_result_;
};

typedef boost::shared_ptr<starter> trw_ptr;

}
