#pragma once

#include <ymod_webserver/request.h>
#include "parser/char_sets.h"
#include "http_stream.h"

namespace ymod_webserver {

class validator
{
    typedef void (
        validator::*header_handler_t)(request_ptr& req, header_map_t::const_iterator i_header);
    typedef std::map<string, header_handler_t> header_handlers_t;

public:
    validator() : websocket_count_(0), vhost_parsed_(false)
    {
    }

    bool operator()(const endpoint& ep, request_ptr& req)
    {
        if (req->proto_version.first < 1 || req->proto_version.second < 1)
            req->connection = connection_close;
        for (header_map_t::iterator i_header = req->headers.begin(),
                                    i_header_end = req->headers.end();
             i_header != i_header_end;
             ++i_header)
        {
            header_handlers_t::const_iterator i_handler = header_handlers_.find(i_header->first);
            if (i_handler != header_handlers_.end()) (this->*(i_handler->second))(req, i_header);
        }
        if ((req->upgrade_to == upgrade_to_websocket76 && websocket_count_ != 2) ||
            (req->upgrade_to == upgrade_to_websocket07 && websocket_count_ != 1) ||
            (req->upgrade_to == upgrade_to_websocket08 && websocket_count_ != 1))
        {
            throw parse_error(
                "validator", "websocket key header not found", "websocket key header not found")
                << BOOST_ERROR_INFO;
        }
        if (req->method == methods::mth_post)
        {
            header_map_t::iterator i_header = req->headers.find("expect");
            return (i_header != req->headers.end() && i_header->second == "100-continue");
        }
        if (!vhost_parsed_)
        {
            req->vhost = ep.default_host;
        }
        return false;
    };

private:
    void on_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_connection_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_transfer_encoding_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_upgrade_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_host_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_content_length_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_content_type_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_content_encoding_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_websocket76_key(request_ptr& req, header_map_t::const_iterator iter);
    void on_websocket_key(request_ptr& req, header_map_t::const_iterator iter);
    void on_websocket_version(request_ptr& req, header_map_t::const_iterator iter);
    void on_origin_header(request_ptr& req, header_map_t::const_iterator iter);

    void on_accept_header(request_ptr& req, header_map_t::const_iterator iter);
    void on_accept_encoding_header(request_ptr& req, header_map_t::const_iterator iter);

    static const header_handlers_t header_handlers_;
    unsigned websocket_count_;
    bool vhost_parsed_;
};

}
