%define _builddir	.
%define _sourcedir	.
%define _specdir	.
%define _rpmdir		.

Name:		ymod_webserver
Version:	%{yandex_mail_version}
Release:	%{yandex_mail_release}

Summary:	Yandex's WEB Server from YPlatform
License:	Yandex License
Group:		System Environment/Libraries
Packager:	Boris B. Zhmurov <zhmurov@yandex-team.ru>
Distribution:	Red Hat Enterprise Linux

Requires:	boost >= 1.43.0
Requires:	yplatform = %{version}-%{release}

BuildRequires:	boost-devel >= 1.43.0
BuildRequires:  yplatform-devel = %{version}-%{release}

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root


%description
WEB Server for YPlatform based services


%package	devel
Summary:	Development environment for ymod_webserver
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}


%description	devel
Yandex's WEB Server from YPlatform development files


%package	test
Summary:	Test environment for ymod_webserver
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	yplatform-yloader = %{version}-%{release}

%description	test
Test echo-server module based on ymod_webserver


%build
cmake . -DCMAKE_INSTALL_PREFIX=/usr \
        -DCMAKE_INSTALL_SYSCONFDIR=/etc \
        -DCMAKE_INSTALL_LIBDIR=/usr/lib64 \
        -DCMAKE_INSTALL_INITDIR=%{_initddir} \
        -DCMAKE_BUILD_TYPE=Release
%{__rm} -rf %{buildroot}
%{__make} %{?_smp_mflags}

%install
%{__make} install DESTDIR=%{buildroot}

%post test
if [ $1 = 1 ] ; then
    /sbin/chkconfig --add echo-server
fi
/etc/init.d/echo-server restart
exit 0

%preun test
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del echo-server
    /etc/init.d/echo-server stop
    %{__rm} -f /etc/echo_ws_server/echo-ws-server.conf.yml
fi
exit 0

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_libdir}/modules/ymod_webserver.so

%files devel
%defattr(-,root,root)
%dir %{_includedir}/ymod_webserver

%{_includedir}/ymod_webserver/*.h
%{_includedir}/ymod_webserver/*/*.h

%files test
%defattr(-,root,root)
%{_libdir}/modules/ymod_webservertest.so
%{_sysconfdir}/echo_ws_server/echo-ws-server.conf.yml
%{_initddir}/echo-server

%changelog
* Fri Jan 14 2011 Anton A. Barabanov <becks@yandex-team.ru> 
- initial yandex's rpm build

