#pragma once

#include <ymod_webserver_helpers/content_type.hpp>
#include <yamail/data/serialization/json_writer.h>

namespace ymod_webserver {
namespace helpers {
namespace format {

template <class T>
class Json {
public:
    Json(const T& value) : value(value) {}

    template <class Stream>
    Stream& write(Stream& stream) const {
        return yamail::data::serialization::writeJson(stream, value);
    }

    template <class Function>
    void apply_for_body(Function&& function) const {
        return function(yamail::data::serialization::toJson(value).str());
    }

    static const ContentType& content_type() {
        static const ContentType value {"application", "json"};
        return value;
    }

private:
    const T& value;
};

template <class T>
inline Json<T> json(const T& value) {
    return Json<T>(value);
}

} // namespace format
} // namespace helpers
} // namespace ymod_webserver
