#pragma once

#include <ymod_webserver_helpers/content_type.hpp>

namespace ymod_webserver {
namespace helpers {
namespace format {

namespace detail {

struct BasicText {
    static const ContentType& content_type() {
        static const ContentType value {"text", "plain"};
        return value;
    }
};

} // namespace detail

template <class T>
class Text : public detail::BasicText {
public:
    Text(const T& value) : value(value) {}

    template <class Stream>
    Stream& write(Stream& stream) const {
        return stream << value;
    }

    template <class Function>
    void apply_for_body(Function&& function) const {
        return function(std::to_string(value));
    }

private:
    const T& value;
};

template <>
class Text<std::string> : public detail::BasicText {
public:
    Text(const std::string& value) : value(value) {}

    template <class Stream>
    Stream& write(Stream& stream) const {
        return stream << value;
    }

    template <class Function>
    void apply_for_body(Function&& function) const {
        return function(value);
    }

private:
    const std::string& value;
};

template <>
class Text<const char*> : public detail::BasicText {
public:
    Text(const char* value) : value(value) {}

    template <class Stream>
    Stream& write(Stream& stream) const {
        return stream << value;
    }

    template <class Function>
    void apply_for_body(Function&& function) const {
        return function(value);
    }

private:
    const char* value;
};

template <class T>
inline Text<T> text(const T& value) {
    return Text<T>(value);
}

inline Text<const char*> text(const char* value) {
    return Text<const char*>(value);
}

} // namespace format
} // namespace helpers
} // namespace ymod_webserver
