#pragma once

#ifdef YMOD_WEBSERVER_HELPERS_ENABLE_XML

#include <ymod_webserver_helpers/content_type.hpp>
#include <yamail/data/serialization/xml_writer.h>

namespace ymod_webserver {
namespace helpers {
namespace format {

template <class T>
class Xml {
public:
    Xml(const T& value) : value(value) {}

    template <class Stream>
    Stream& write(Stream& stream) const {
        apply_for_body([&] (const auto& value) { stream << value; });
        return stream;
    }

    template <class Function>
    void apply_for_body(Function&& function) const {
        return function(yamail::data::serialization::toXml(value).str());
    }

    static const ContentType& content_type() {
        static const ContentType value {"text", "xml"};
        return value;
    }

private:
    const T& value;
};

template <class T>
inline Xml<T> xml(const T& value) {
    return Xml<T>(value);
}

} // namespace format
} // namespace helpers
} // namespace ymod_webserver

#endif // YMOD_WEBSERVER_HELPERS_ENABLE_XML
