#pragma once

#include <ymod_webserver/response.h>

namespace ymod_webserver {
namespace helpers {

#define YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(code) \
    template <class TransferEncoded> \
    void code(const TransferEncoded& encoded) const { \
        component.set_code(ymod_webserver::codes::code); \
        encoded.write(component); \
    }

class Response {
public:
    Response(ymod_webserver::response& component) : component(component) {}

    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(continue_request)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(switching_protocols)

    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(ok)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(created)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(accepted)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(non_authoritative_info)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(no_content)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(reset_content)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(partial_content)

    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(multiple_choices)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(moved_permanently)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(found)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(see_other)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(not_modified)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(use_proxy)

    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(temporary_redirect)

    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(bad_request)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(unauthorized)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(payment_required)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(forbidden)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(not_found)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(method_not_allowed)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(not_acceptable)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(proxy_auth_required)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(request_timeout)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(conflict)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(gone)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(length_required)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(precondition_failed)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(request_entity_too_large)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(request_uri_too_long)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(unsupported_media_type)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(requested_range_not_st)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(expectation_failed)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(too_many_requests)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(client_closed_connection)

    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(internal_server_error)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(not_implemented)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(bad_gateway)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(service_unavailable)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(gateway_timeout)
    YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE(version_not_supported)

private:
    ymod_webserver::response& component;
};

#undef YMOD_WEBSERVER_HELPERS_RESPONSE_WITH_CODE

} // namespace helpers
} // namespace ymod_webserver
