#pragma once

#include <ymod_webserver/response.h>

namespace ymod_webserver {
namespace helpers {
namespace transfer_encoding {

template <class Formatted>
class Chunked {
public:
    Chunked(Formatted formatted)
        : formatted(std::move(formatted)) {}

    void write(ymod_webserver::response& response) const {
        const auto& content_type = formatted.content_type();
        response.set_connection(false);
        response.set_content_type(content_type.type, content_type.subType);
        auto stream = response.result_chunked()->client_stream();
        formatted.write(stream);
    }

private:
    Formatted formatted;
};

template <class Formatted>
inline Chunked<std::decay_t<Formatted>> chunked(Formatted&& formatted) {
    return Chunked<std::decay_t<Formatted>>(std::forward<Formatted>(formatted));
}

} // namespace transfer_encoding
} // namespace helpers
} // namespace ymod_webserver
