#pragma once

#include <ymod_webserver/response.h>

namespace ymod_webserver {
namespace helpers {
namespace transfer_encoding {

template <class Formatted>
class FixedSize {
public:
    FixedSize(Formatted formatted)
        : formatted(std::move(formatted)) {}

    void write(ymod_webserver::response& response) const {
        const auto& content_type = formatted.content_type();
        response.set_content_type(content_type.type, content_type.subType);
        formatted.apply_for_body([&] (const auto& value) { response.result_body(value); });
    }

private:
    Formatted formatted;
};

template <class Formatted>
inline FixedSize<std::decay_t<Formatted>> fixed_size(Formatted&& formatted) {
    return FixedSize<std::decay_t<Formatted>>(formatted);
}

} // namespace transfer_encoding
} // namespace helpers
} // namespace ymod_webserver
