import os
import yaml

from library.python import resource
from mail.devpack.lib import helpers
from mail.devpack.lib.components.base import YplatformComponent
from mail.webmail_config.lib.make_config import make_config
from mail.devpack.lib.components.sharpei import Sharpei
from mail.devpack.lib.components.tvmapi import TvmApi


class York(YplatformComponent):
    NAME = "york"
    DEPS = [Sharpei, TvmApi]

    @staticmethod
    def gen_config(port_generator, config=None):
        return YplatformComponent.gen_config(port_generator, config)

    def __init__(self, env, components):
        super(York, self).__init__(env, components, binary_name='york', custom_path='york')

    def init_root(self):
        self.yhttp.init_root()

        etc_path = self.yhttp.get_etc_path()
        helpers.write2file(resource.find('york/tvm_secret'), os.path.join(etc_path, 'tvm_secret'))

        base = resource.find('york/config-base.yml')

        service_yaml = yaml.full_load(resource.find('york/service.yaml'))
        common_yaml = yaml.safe_load(resource.find('webmail_config/common.yaml'))
        config = self.yhttp.format_config(make_config('development', base, service_yaml, common_yaml, silent=True))
        helpers.write2file(config, os.path.join(etc_path, 'config-base.yml'))

        etc_macs_pg_path = os.path.join(self.get_root(), 'etc', 'macs_pg')
        helpers.mkdir_recursive(etc_macs_pg_path)
        helpers.write2file(resource.find("macs_pg/query.conf"), os.path.join(etc_macs_pg_path, 'query.conf'))

        config = resource.find('york/config-devpack.yml').decode('utf-8')
        config = self.yhttp.format_config(
            config,
            sharpei_port=self.components[Sharpei].webserver_port(),
            tvm_port=self.components[TvmApi].port
        )
        helpers.write2file(config, self.yhttp.get_config_path())

    def start(self):
        self.yhttp.start('{"pong":"pong"}')

    def stop(self):
        self.yhttp.stop()

    def info(self):
        res = self.yhttp.info()
        res.update({"state": self.state})
        return res

    def get_root(self):
        return self.yhttp.get_root()

    def webserver_port(self):
        return self.yhttp.webserver_port

    def ping(self):
        return self.yhttp.ping()

    def request_get(self, endpoint, **kwargs):
        url = self.yhttp.make_url(endpoint, **kwargs)
        return self.yhttp.get(url, headers={'X-Ya-Service-Ticket': self.service_ticket})

    def request_post(self, endpoint, **kwargs):
        url = self.yhttp.make_url(endpoint, **kwargs)
        return self.yhttp.post(url, data=None, headers={'X-Ya-Service-Ticket': self.service_ticket})

    @property
    def service_ticket(self):
        return self.components[TvmApi].get_ticket('tests', 'york')
