#pragma once

#include <yplatform/ptree.h>
#include <macs_pg/service/factory.h>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <yamail/data/deserialization/ptree.h>
#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>

BOOST_FUSION_DEFINE_STRUCT((york), PoolCfg,
        (std::int64_t, connect_timeout_ms)
        (std::int64_t, queue_timeout_ms)
        (std::int64_t, query_timeout_ms)
        (std::int64_t, max_connections)
)

BOOST_FUSION_DEFINE_STRUCT((york), SharpeiCfg,
        (std::string, cluster_client_module)
)

BOOST_FUSION_DEFINE_STRUCT((york), PgCfg,
        (york::PoolCfg, pool)
        (york::SharpeiCfg, sharpei)
        (std::int64_t, transaction_timeout_ms)
        (std::string, query_conf)
        (std::string, user)
)

BOOST_FUSION_DEFINE_STRUCT((york), UnsubscribeWorkerCfg,
        (std::int64_t, delay_sec)
        (std::int64_t, max_task_count)
)

BOOST_FUSION_DEFINE_STRUCT((york), FolderArchivation,
        (std::string, type)
        (std::uint32_t, max_folder_size)
        (std::uint32_t, keep_days)
)

namespace york {

using TVM2Module = ymod_tvm::tvm2_module;
using TVM2ModulePtr = std::shared_ptr<TVM2Module>;
using TVMGuard = tvm_guard::Guard<TVM2Module>;
using TVMGuardPtr = std::shared_ptr<TVMGuard>;

struct Config {
    Config(const yplatform::ptree& cfg, TVM2ModulePtr tvm2Module) {
        pg = ::yamail::data::deserialization::fromPtree<PgCfg>(cfg.get_child("pg"));
        if (pg.sharpei.cluster_client_module.empty()) {
                throw std::invalid_argument("sharpei's cluster_client_module is empty");
        }
        worker = ::yamail::data::deserialization::fromPtree<UnsubscribeWorkerCfg>(cfg.get_child("unsubscribe_worker"));
        archivation = ::yamail::data::deserialization::fromPtree<FolderArchivation>(cfg.get_child("folder_archivation_defaults"));
        queryConf = macs::pg::readQueryConfFile(pg.query_conf);

        const auto guard = tvm_guard::init(cfg.get_child("tvm_guard"), tvm2Module);
        tvmGuard = std::make_shared<TVMGuard>(guard);
    }
    PgCfg pg;
    UnsubscribeWorkerCfg worker;
    FolderArchivation archivation;
    ::macs::pg::QueryConf queryConf;
    TVMGuardPtr tvmGuard;
};

using ConfigPtr = std::shared_ptr<Config>;

} //namespace york
