#pragma once

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wsign-conversion"
#endif

#include <yplatform/module.h>

#ifdef __clang__
#pragma clang diagnostic pop
#endif

#include <internal/config.h>
#include <internal/macs.h>
#include <internal/sharpei.h>

namespace york {

struct Module: public yplatform::module {
    Module() { }

    void init(const yplatform::ptree& cfg);
    void start();
    void stop();

private:
    void bindHandlers(const yplatform::ptree& cfg);
    ConfigPtr config;
    SuperPool superPool;

    auto getMacs() {
        return [this](const std::string& uid, auto log, ConfigPtr cfg) {
            return superPool.getMacsService(uid, std::move(log), cfg);
        };
    }

    auto getShard() {
        return [this](const std::string& shardId, auto log, ConfigPtr cfg) {
            return superPool.getMacsShard(shardId, std::move(log), cfg);
        };
    }

    class RunStatus final {
    public:
        operator bool() const noexcept {
            return running.load(std::memory_order_acquire);
        }

        void reset() noexcept {
            running.store(false, std::memory_order_release);
        }

    private:
        std::atomic<bool> running{ true };
    };
    RunStatus running;
};

}
