#pragma once

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wsign-conversion"
#endif

#include <ymod_webserver/server.h>
#include <ymod_webserver/request.h>

#ifdef __clang__
#pragma clang diagnostic pop
#endif

#include <internal/server/response.h>

#include <boost/optional.hpp>
#include <boost/lexical_cast.hpp>


namespace york {
namespace server {

class Context {
    ymod_webserver::response_ptr stream;
public:
    Context(ymod_webserver::response_ptr stream)
        : stream(stream)
    { }

    Response response() const {
        return Response(stream);
    }

    auto method() const {
        return stream->request()->method;
    }

    std::string endpoint() const {
        return stream->request()->url.make_full_path();
    }

    boost::optional<std::string> getOptionalArg(const std::string& name) const {
        auto iter = stream->request()->url.params.find(name);
        return iter == stream->request()->url.params.end() ? boost::none : boost::make_optional(iter->second);
    }

    std::string getHeader(std::string name, const std::string& def = "") const {
        boost::algorithm::to_lower(name);
        auto iter = stream->request()->headers.find(name);
        return iter == stream->request()->headers.end() ? def : iter->second;
    }

    boost::optional<std::string> getOptionalHeader(std::string name) const {
        boost::algorithm::to_lower(name);
        auto iter = stream->request()->headers.find(name);

        return iter == stream->request()->headers.end() ? boost::none : boost::make_optional(iter->second);
    }

    std::string uniqId() const {
        return stream->request()->ctx()->uniq_id();
    }

    std::string requestId() const {
        return getHeader("X-Request-Id");
    }

    std::string userIp() const {
        const auto it = getOptionalHeader("X-Real-IP");
        return (it && !(it->empty())) ? *it : stream->request()->context->remote_address;
    }
};

}
}
