#pragma once

#include <internal/server/handlers/helpers.h>

BOOST_FUSION_DEFINE_STRUCT((york)(server)(handlers), RemoveArchivationRuleParams,
                           (std::string, uid)
                           (boost::optional<std::string>, shared_folder_fid) )

BOOST_FUSION_DEFINE_STRUCT((york)(server)(handlers), RemoveArchivationRuleResult,
                           (bool, ok) )

namespace york {
namespace server {
namespace handlers {

template<class ServiceT, class ContextT, class YieldT>
void executeMacsRemoveArchivationRule(ServiceT& mailbox,
                                      ContextT& ctx,
                                      RemoveArchivationRuleParams params,
                                      YieldT myield) {
    const auto sharedFolderFid = params.shared_folder_fid
                      ? *params.shared_folder_fid
                      : mailbox.folders().getAllFolders(myield).fid(macs::Folder::Symbol::inbox);

    mailbox.folders().removeArchivationRule(sharedFolderFid, myield);

    ctx.response().ok(RemoveArchivationRuleResult{true});
}

template<typename MacsGetter>
auto makeRemoveArchivationRuleHandler(ConfigPtr cfg, MacsGetter getMacsService) {
    return makeHandler([cfg, getMacsService](auto& ctx, const auto& log, auto yield) {
        RemoveArchivationRuleParams params;
        if (!getArgs(ctx, params)) {
            return;
        }
        auto mailbox = getMacsService(params.uid, log, cfg);
        executeMacsRemoveArchivationRule(*mailbox, ctx, std::move(params), wrap(yield));
    });
}

}
}
}
