#pragma once

#include <internal/server/operations/unsubscribe_operation_impl.h>

namespace york {
namespace server {
namespace handlers {

template <typename ConfigPtr, typename MacsGetter>
auto makeUnsubscribeHandler(ConfigPtr cfg, MacsGetter getMacsService) {
    return makeHandler([cfg, getMacsService](auto& ctx, auto log, auto yield) {
        UnsubscribeParams params;
        if (!getArgs(ctx, params, log)) {
            return;
        }

        auto subscriberMailbox = getMacsService(params.subscriber_uid, log, cfg);
        auto ownerMailbox = getMacsService(params.owner_uid, log, cfg);

        auto unsibscribe = makeUnsubscribeOperation(
                    *ownerMailbox, *subscriberMailbox,
                    ctx, params, log);
        unsibscribe.execute(wrap(yield));
    });
}

} // namespace handlers
} // namespace server
} // namespace york
