#pragma once

#include <internal/server/handlers/helpers.h>
#include <internal/timer.h>
#include <internal/logger/logger.h>
#include <boost/range/adaptors.hpp>
#include <boost/range/join.hpp>
#include <macs_pg/subscription/subscription_state.h>
#include <macs_pg/subscription/subscription_action.h>

BOOST_FUSION_DEFINE_STRUCT((york)(server)(handlers), UnsubscribeParams,
                           (std::string, subscriber_uid)
                           (std::string, owner_uid)
                           (boost::optional<std::string>, shared_folder_fid) )

BOOST_FUSION_DEFINE_STRUCT((york)(server)(handlers), UnsubscribeResult,
                           (bool, ok) )

namespace york {
namespace server {
namespace handlers {
namespace operations {

using FidVec = std::vector<macs::Fid>;
using FolderVec = std::vector<macs::Folder>;
using SubsFolderVec = std::vector<macs::SubscribedFolder>;
using SubscriptionVec = std::vector<macs::Subscription>;

template <typename Impl>
class UnsubscribeOperation {
public:
    UnsubscribeOperation(std::shared_ptr<Impl> impl)
        : impl_(impl) {}

    template <typename Myield>
    void execute(Myield myield) {
        const auto sharedFolderFid = impl().params.shared_folder_fid
                          ? *impl().params.shared_folder_fid
                          : impl().ownerMailbox.folders().getAllFolders(myield).fid(macs::Folder::Symbol::inbox);

        SubsFolderVec foldersToClean = impl().getSubfolders(sharedFolderFid, myield);
        if (foldersToClean.empty()) {
            impl().removeSubscription(sharedFolderFid, myield);
        } else {
            impl().terminate(foldersToClean, myield);
            impl().createUnsubscribeTask(foldersToClean, myield);
        }

        impl().ctx.response().ok(UnsubscribeResult{true});
    }

private:
    std::shared_ptr<Impl> impl_;
    Impl& impl() { return *impl_; }
};

template <typename Impl>
inline auto makeUnsubscribeOperationWithImpl(std::shared_ptr<Impl> impl) {
    return UnsubscribeOperation<Impl>(impl);
}

} // namespace operations
} // namespace handlers
} // namespace server
} // namespace york
