#pragma once

#include <sharpei_client/sharpei_client.h>

#include <internal/config.h>
#include <internal/logger/logger.h>

namespace york::sharpei {

template <typename Logger>
inline auto makeSharpeiParams(const SharpeiCfg& cfg, Logger logger, const std::string caller) {
    using ::sharpei::client::http::Timeout;
    ::sharpei::client::Settings s;
    s.onHttpException = [logger, caller] (const std::exception& e) {
        YORK_LOG_ERROR(logger, caller + " exception", log::exception=e);
    };
    s.onHttpError = [logger, caller] (const ::sharpei::client::ErrorCode& e, const std::string& msg) {
        YORK_LOG_ERROR(logger, caller + " error: " + msg, log::error_code=e);
    };
    s.httpClient = {.clusterClientModuleName = cfg.cluster_client_module};
    return s;
}

template <typename Logger>
::sharpei::client::SharpeiClientPtr getSharpeiClient(const SharpeiCfg& cfg, Logger logger) {
    return ::sharpei::client::createSharpeiClient(
                makeSharpeiParams(cfg, std::move(logger), "sharpei client http client"),
                {"", "", "york", "", ""});
}

} //namespace york::sharpei
