#pragma once

#include <boost/asio.hpp>
#include <boost/asio/spawn.hpp>
#include <boost/asio/steady_timer.hpp>
#include <chrono>

namespace york {
namespace timer {

class Timer {
public:
    Timer(::boost::asio::io_service& io) : io_(io) {}

    template <typename Duration, typename Yield>
    void wait(Duration&& timeout, Yield yield) {
        ::boost::asio::steady_timer timer(io_);
        timer.expires_from_now(std::forward<Duration>(timeout));
        timer.async_wait(yield);
    }

private:
    ::boost::asio::io_service& io_;
};

} // namespace timer
} // namespace york

