#include <internal/macs.h>
#include <internal/sharpei.h>

#include <macs_pg/macs_pg.h>

namespace york {

auto SuperPool::createPool(const PoolCfg& cfg, boost::asio::io_service& io) {
    using Ms = macs::pg::Milliseconds;
    return macs::pg::ConnectionPoolFactory()
            .connectTimeout(Ms(cfg.connect_timeout_ms))
            .queueTimeout(Ms(cfg.queue_timeout_ms))
            .queryTimeout(Ms(cfg.query_timeout_ms))
            .maxConnections(static_cast<std::size_t>(cfg.max_connections))
            .ioService(io)
            .product();
}

void SuperPool::init(const PoolCfg& cfg) {
    for (const auto& ioPool : yplatform::global_net_reactor->get_pools()) {
        auto io = ioPool->io();
        pools.emplace(io, createPool(cfg, *io));
    }
}

} //namespace york
