from cpython cimport *
from libcpp.string cimport string
from libcpp.unordered_map cimport unordered_map
from libcpp.vector cimport vector
from libcpp.memory cimport shared_ptr

cimport mail.unistat.cpp.cython.run_cpp
from mail.unistat.cpp.cython.logs cimport *
from mail.unistat.cpp.cython.meters cimport *

cimport york_logs_cpp
cimport york_meters_cpp


cdef class CountErrorCategories:
    cdef shared_ptr[york_meters_cpp.CountErrorCategories] __impl

    def __cinit__(self, unordered_map[string, string] expectedErrors, string name):
        self.__impl.reset(new york_meters_cpp.CountErrorCategories(expectedErrors, name))


cdef class YorkLog:
    cdef shared_ptr[york_logs_cpp.YorkLog] __impl

    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[york_logs_cpp.YorkLogMeters] cm
        for m in cppMeters:
            if isinstance(m, CountErrorCategories):
                cm.push_back(york_logs_cpp.YorkLogMeters((<CountErrorCategories>m).__impl))
            else:
                raise AttributeError("Unknown meter type for YorkLog")
        self.__impl.reset(new york_logs_cpp.YorkLog(pm, cm, fastForward, <const char*>path))


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[logs_cpp.Logs] cppLogs
    for l in pyLogs:
        if isinstance(l, YorkLog):
            cppLogs.push_back(
                logs_cpp.Logs((<YorkLog>l).__impl)
            )
        elif isinstance(l, HttpClientLog):
            cppLogs.push_back(
                logs_cpp.Logs((<HttpClientLog>l).__impl)
            )
        elif isinstance(l, SupervisorLog):
            cppLogs.push_back(
                logs_cpp.Logs((<SupervisorLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")
    mail.unistat.cpp.cython.run_cpp.run(host, port, cppLogs, yplatformLogPath, logLevel)
