## YPlatform - что это и зачем?

Набор библиотек для построения высоконагруженных асинхронных серверов. Главная цель - обеспечить максимальное переиспользование готовых компонентов и структурное единообразие приложений.

В первую очередь YPlatform - это набор инструментов и концепций. Решение схожих задач схожими проверенными методами - это важный элемент инженерной культуры. Это помогает бережливо расходовать усилия команды как на разработку, так и на эксплуатацию и поддержку приложений.

Корневой идеей является принцип модульности в дизайне приложений: функции и ответственность приложения разделяются на модули в соответствии с дизайном сервиса. Между модулями возможны зависимости и совместная работа с различными разделяемыми ресурсами.

YPlatform поставляется в виде вспомогательных библиотек, загрузчика и набора готовых модулей, решающих узкий круг технических задач.

### Как всё устроено

![](doc/modules_struct.png)

- Loader - управление жизненным циклом приложения
- Reactors - основа тредной модели приложения: очереди событий, потоки для их обработки и создания IO объектов во всем приложении
- Loggers - сквозные компоненты для логирования в приложении
- Modules - репозиторий модулей и сами модули - блоки для построяния функциональности приложений
- Tasks - все, что связано с задачами
- Lib - вспомогательные библиотеки для создания приложений
  - algorithm - некоторые алгоритмы: congestion control, leaky bucket, WRS
  - config - yaml конфиги на базе yamlcpp с наследованием
  - convert- преобразование текста между кодировками
  - [coroutine](doc/coroutine.md) - вспомогательные примитивы для stackless корутин
  - encoding - некоторые функции для кодирования/декодирования: url, base64, urlsafe base64, QP
  - [future](doc/future.md) - асинхронные future с колбэками
  - hash - некоторые хэш-функции
  - [log](doc/log.md) - логирование на базе spdlog, в том числе tskv
  - [net](doc/net.md) - сетевые примитивы, о основном над boost asio: сокеты, SSL стрим, клиент-сервер, буферы, кэширующий DNS резолвер
  - reactor - реактор и другие примитивы над boost asio io_context
  - zerocopy - эффективные сетевые буферы без копирования данных
  - [util](doc/util.md) - прочие вспомогательные примитивы

### Готовые модули

[Web server](../ymod_webserver/README.md) - асинхронный сервер для HTTP и WebSocket нагрузки.

[HTTP client](../ymod_httpclient/README.md) -асинхронный HTTP и HTTP/2 клиент.

[TVM](../ymod_tvm/README.md) - модуль для работы с [TVM2](https://wiki.yandex-team.ru/passport/tvm2/) тикетами.

[Rate controller](../ymod_ratecontroller/README.md) - модуль для ограничения параллельности выполнения задач.

[Stat server](../ymod_statserver/README.md) - по запросу собирает и выдает статистику со всех остальных модулей в приложении.

[Metric server](../ymod_metricserver/README.md) - то же, что и stat server, но из статистики выдает только метрики в обобщенном формате.

PQ - асинхронный клиент к PostgreSQL.

Lease - клиент и сервер распределенных локов.

Messenger - позволяет обмениваться бинарными сообщениями по TCP соединению.

### Разработка приложений

- [общая структура](doc/guide/app_common.md)

- [ресурсы приложения](doc/guide/app_resources.md)

- разработка модулей

  - [создание и конфигурация](doc/guide/modules_common.md)

  - [поиск и использование ресурсов](doc/guide/modules_resources.md)

  - [задачи и контекст](doc/guide/modules_task_context.md)

  - [тестирование](doc/guide/modules_test.md)

- [конфигурирование](doc/app_config.md)

- [обработка ошибок](doc/guide/errors.md)

