#include <yplatform/application/config/yaml_to_ptree.h>
#include <yplatform/application/config/loader.h>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/property_tree/json_parser.hpp>
#include <boost/version.hpp>
#include <iostream>
#include <string>

using namespace std;
using namespace utils::config;

int main(int argc, char** argv)
{
    ptree config;
    if (argc < 2)
    {
        std::cout << "Usage: config-dumper <filename> [-yml]\n";
        return 1;
    }
    loader::from_file(argv[1], config);

    if (argc > 2 and strcmp(argv[2], "-yml") == 0)
    {
        // dump to yaml
        yaml_to_ptree::dump(std::cout, config);
        std::cout << std::endl;
    }
    else
    {
        boost::property_tree::xml_parser::xml_writer_settings<std::string> settings(' ', 4);
        boost::property_tree::xml_parser::write_xml(std::cout, config, settings);
    }

    return 0;
}
