## Deadline propagation
### Мотивация
Одна из причин, усугубляющих аварии и сбои, это отсутствие на бэкенде информации о таймауте клиентов. Это приводит к тому, что бэкенд занимается работой, результат которой никому уже не нужен, и не может самостоятельно выйти из состояния перегрузки.

### Принцип работы
В yplatform::task_context хранится глобальный дедлайн на запрос.

ymod_httpclient учитывает в таймауте запроса глобальный дедлайн и добавляет в запрос заголовок ```X-Request-Timeout```, содержащий таймаут в миллисекундах.

ymod_webserver получает переданный в запросе таймаут и записывает его в task_context.

Также есть возможность работать с дедлайном в клиентском коде. Для его проверки используются функция task_context::is_cancelled() и геттер task_context::deadline(), для модификации - сеттер task_context::deadline().

Таким образом, просто прокидывая контекст запроса, пользователи получают возможность использовать deadline propagation из коробки.

### Пример
Дано:
* связка из 4 бэкендов
* таймаут запроса 200 миллисекунд
* rtt между бэкендами 20 миллисекунд
* бэкенды обрабатывают запрос за 5 миллисекунд
* кроме бэкенда D, который перегружен и копит очередь запросов

![img](https://jing.yandex-team.ru/files/kharybin/deadline_propagation-4.png)

Последовательность действий:
1. Бэкенд A делает запрос в бэкенд B и передает заголовок ```X-Request-Timeout: 200```
1. Бэкенд B обрабатывает запрос 5 миллисекунд и делает запрос в бэкенд C с заголовком ```X-Request-Timeout: 195```
1. Бэкенд C обрабатывает запрос за 5 миллисекунд и отвечает
1. Бэкенд B делает запрос в бэкенд D с заголовком ```X-Request-Timeout: 170```
1. Бэкенд D принимает запрос и складывает его в очередь
1. Запрос на бэкендах A и B таймаутится
1. Бэкенд D понимает, что запрос никто не ждет и тоже отбрасывает его, избавляя себя от лишней работы

### Ссылки
* [Addressing Cascading Failures](https://landing.google.com/sre/sre-book/chapters/addressing-cascading-failures/)
* [A Distributed Deadline Propagation Approach to Tolerate Long-Tail Latency in Datacenters](http://acs.ict.ac.cn/baoyg/downloads/APSys14-D2P.pdf)
