## Ресурсы приложения

В этом разделе речь пойдет об общих ресурсах для совместного использования пользовательскими модулями. Вот их список:

- реакторы
- логгеры
- репозиторий модулей
- репозиторий контекстов

Эти ресурсы инициализируются глобально на всё приложение. К ним можно обратиться через семейство функций `yplatform::find` (подробнее об этом можно почитать в разделе "Разработка модулей").

Такой глобальный стейт - это исторически сложившееся решение для доступа к разделяемым ресурсам. Существует еще один механизм распространения ресурсов. Суть его в том, что модуль инициализируется конфигом и `io_context` (либо реактором) - и через этот контекст можно получить любые другие ресурсы:

![](io_resources_lookup.png)

Оба подхода поддерживаются для совместимости с существующими модулями. Второй при этом предпочтительнее - он уменьшает связность и упрощает тестирование, так как отвязывает модуль от глобального стейта. Через `io_context` нельзя получить другой `io_context` или реактор. Это ограничение позволяет избежать перекрестных ссылок между реакторами.

### Реакторы

![](../reactor.png)

Реактор - это один или несколько `boost::asio::io_context`, а также потоки, к ним привязанные.

Упрощенно каждый `io_context` - это очередь событий для обработки. Например:

- завершилось чтение данных из сокета в буфер
- сработал таймер
- отменена асинхронная операция
- нужно вызвать кастомную функцию, которую в реактор закинул какой-то из модулей

Все эти события по сути являются колбэками и исполняются в потоках реактора:

![](reactor_events.png)

Один реактор представляет собой несколько таких независимых очередей. Реакторы имеют имена. В любом приложении есть реактор с именем "global" - он используется модулями как дефолтный.

Большинство модулей использует для своих задач минимум один реактор. Несколько модулей могут совместно использовать один реактор - это настраивается в конфиге приложения. Под использованием здесь подразумевается, что модуль создает io-объекты на реакторе либо обращается к реактору напрямую.

Бывает и неявное использование. Например, модуль получил от ymod_webserver объект класса `stream` и послал ответ пользователю через `stream::result()`. В этом случае асинхронные операции записи в сокет будут выполняться на реакторе ymod_webserver. Подробнее про исполнение асинхронных операций и их связь с потоками приложения можно почитать в разделе "Рантайм".

### Логгеры

Чтобы писать лог в файл, используются специальные объекты - логгеры. Они бывают нескольких типов:

- `log::source` - для обычных текстовых логов
- `log::tskv_logger` - для типизированных логов

Про настройку логгеров можно узнать в разделе "Конфигурирование", а про использование в коде - в разделе "Разработка модулей".

### Репозиторий модулей

В него загрузчик сохраняет все модули приложения. Благодаря этому они (модули) могут находить друг друга и взаимодействовать через публичные интерфейсы. Поиск проводится по имени модуля.

Инициализирует, запускает и останавливает модули только загрузчик. Технически возможно получить из репозитория модуль и управлять его состоянием - без особой необходимости так делать не рекомендуется.

Некоторые модули (например, statserver и metricserver) обходят весь репозиторий, чтобы собрать статистику по каждому модулю.

### Репозиторий контекстов

Глобальный репозиторий контекстов умеет хранить [task_context](../task_context.md) - контексты выполняемых в данный момент задач.

Работа с репозиторием сводится к простым операциям:

- добавить контекст в репозиторий при старте задачи
- удалить после ее завершения

Первое важное его применение - уметь доделать все задачи перед остановкой приложения. Если есть контексты в репозитории, то загрузчик при остановке приложения будет ждать, пока все задачи не завершатся.

Другое применение - модуль statserver умеет по запросу собирать и отдавать статистику всех исполняемых задач. Используется не очень широко и имеет ряд ограничений по производительности.

