## Задачи и контекст

Прочтите "[task_context](../task_context.md)", чтобы ознакомиться с базовой концепцией.

Советы по разработке модулей:

- в функциях публичного интерфейса модуля принимайте первым параметром task_context_ptr, чтобы ваш модуль был максимально встроен в экосистему - поддерживал deadline propagation, сквозное логирование
- если ваш модуль принимает от другого серверного модуля задачу, то скорее всего она лежит в репозитории контекстов и приложение будет ждать эту задачу при остановке. Ваш модуль может удалить контекст из репозитория для всех или некоторых задач, чтобы обеспечить желательное поведение системы
- если ваш модуль выполняет для одной задачи много разных операций, проверяйте между задачами `task_context::cancelled()`, чтобы остановить обработку отмененной задачи и не тратить ресурсы на ненужную работу
- также вы можете сами выставить задаче флаг `cancelled`
- интерфейс `task_context` позволяет изменять дедлайн задачи