## Тестирование

Тестирование модулей сводится к юнит-тестам и интеграции с другими модулями.

Основная рекомендация - как можно больше функциональности покрывать юнит тестами. Это позволит уменьшить цикл обратной связи и в конечном счете ускорить разработку.

Написание самих тестов выходит за рамки данной статьи.

Интеграцию нескольких модулей можно протестировать как тестами на всё приложение, так и специальными юнит-тестами. По возможности выбирайте второй вариант.

Простой модуль без зависимостей тестируется как обычный класс.

Предположим, что модуль `dependent_module` в реализации через `yplatform::find()` ищет `module` и использует как зависимость. В этом случае тест может выглядеть следующим образом:

````c++
#include <yplatform/app_service.h>
#include <yplatform/module.h>

void test()
{
    boost::asio::io_context io;
    auto module = std::make_shared<module>();
    yplatform::register_module(io, "name", module);
    auto dependent = std::make_shared<dependent_module>(io);
    // дальше сам тест
}
````

Проинициализировать логи в тестах можно так:

```c++
yplatform::log::init_console(io);
```

