## Жизненный цикл приложения, время жизни объектов

Это самая важная тема в понимании архитектуры асинхронных приложений на платформе.

Жизненный цикл приложения состоит из четырех ключевых стадий: инициализаци, старт, исполнение, остановка.

![img](lifecycle.png)

### Стадия 1: инициализация
Эта стадия нужна для подготовки к старту разделяемых ресурсов и модулей. Сначала инициализируются логгеры и реакторы ввода-вывода, затем по очереди создаются модули (согласно порядка в конфиге), у каждого модуля вызывается init().
Исполнение строго однопоточное. В конце этой стадии делается setuid и setgid, если нужно.

Рекомендуется на этой стадии в init() модулей биндиться на нужные порты, вешать обработчики на другие модули.

### Стадия 2: старт
Вызывается start() модулей и запускаются реакторы. Начиная с этой стадии приложение исполняется в несколько потоков, что нужно учитывать при программировании ваших модулей. Серверные модули с этого момента начинают принимать входящие соединения, а модули-планировщики - генерировать задачи.

### Стадия 3: исполнение
Во время работы модулей по внешнему сигналу (SIGHUP) может вызываться reload(). Он вызывается последовательно для каждого модуля в одном потоке. Однако стоит помнить, что сам модуль работает в многопоточном окружении. В reload() модуль может применить новые настройки или выполнить какую-то внутреннюю логику.
Также по сигналу переоткрываются лог-файлы.

### Стадия 4: остановка
По внешнему сигналу приложение вызывает stop() у каждого модуля. Обычно stop() имеет смысл только для серверных модулей и планировщиков - после этого вызова модуль перестает принимать новые входящие соединения и генерировать задания.
Далее у всех контекстов (task_context) в глобальном репозитории контекстов (`yplatform::context_repo`) вызывается cancel(), затем приложение переходит в режим ожидания до тех пор, пока этот репозиторий не опустеет. Это нужно для того, чтобы гарантированно закончить все важные задачи перед завершением программы.

Следующим шагом вызывается fini() каждого модуля, после чего приложение сбрасывает все shared_ptr на все модули. Таким образом, все модули, которые не выполняли фоновой работы и никем не использовались, будут удалены на этом шаге.

В завершение останавливаются и удаляются глобальные реакторы. В этот момент времени каждый `asio::io_service` потенциально имеет в очереди либо уже исполняет какие-то задачи. Сначала вызывается `asio::io_service::stop()` и join всех потоков, в результате в каждом `asio::io_service` остаются невыполненные задания, ожидающие таймеры и другие асинхронные объекты. Теперь исполнение программы снова стало однопоточным. Вызываются деструкторы объектов `asio::io_service`, что порождает удаление всех хранимых хэндлеров из очередей и служебных объектов `asio::io_service`. В свою очередь это приводит к удалению модулей, на которые оставались ссылки как `shared_from_this`. Хэндлеры при этом не вызываются.

Есть одно исключение - ваши собственные RAII объекты и `yplatform::future`. При удалении future вызывается хэндлер с исключением `broken_promise_exception`.

Убедитесь, что ваш модуль либо использует в асинхронных операциях хэндлеры без RAII, либо оставляют в хэндлерах ссылку на себя через `shared_from_this`.
