## yplatform::log

### Интро
Изначально всё логирование было глобальным через boost log.

Для логирования в глобальный логер использовался макрос L_ или L_SEV. Доступ к самому объекту глобального логера реализован через макрос YGLOBAL_LOGGER.

Чтобы добавить в лог идентификатор контекста, использовался макрос TASK_LOG - если в контексте есть свой логгер, то логи пишутся через него, в противном случае - через глобальной логгер.

Позднее был смещен акцент с логгера контекста на модульное логирование. Это было сделано для того, чтобы добавить большей гибкости фильтрации.

Каждый логгер имеет свое имя. Глобальный логгер имеет имя general. Для каждого модуля при загрузке создается свой логгер, а в качестве имени используется имя модуля из конфига. Чтобы сохранить возможность логировать от имени контекста, уникальный идентификатор контекста явным образом добавляется к каждой логируемой записи.

Чтобы упростить прокидывание логера в модули и крупные классы, существует [`yplatform::log::contains_logger`](../include/yplatform/log/contains_logger.h). Все, что вам нужно - это наследоваться от этого класса и передать ему экземпляр логера текущего модуля в конструктор или через сеттер.

### Инициализация
Если ваше приложение запускается загрузчиком yplatform, то логи инициализируются автоматически. 
[пример инициализации stdout лога](../examples/log/init_console/main.cc) 
[пример инициализации файлового лога](../examples/log/text_file/main.cc)  

### Логгеры

Бывают двух типов:

- `log::source` - для обычных текстовых логов
- `log::tskv_logger` - для типизированных логов

### Запись
Запись в лог осуществляется через макросы:

- **L_(severity)** 
Обычно используется в случаях, когда нужно быстро что-то залогировать. Пишет в глобальный логер.
- **LDEBUG_, LINFO_, LWARN_, LERR_, LALERT_, LEMERG_** 
Рассмотрим на примере **LINFO_**, остальные аналогичны. 
```LINFO_(this)``` запись с привязкой к модулю платформы 
```LINFO_(context)``` запись через логер из task_context с указанием ID контекста 
```LINFO_(this, context)``` запись с логером модуля и ID контекста

- **YLOG(logger, severity)** 
Более абстрактный макрос для записи через логер. Используется для typed лога, а также из других макросов.

При записи перехватываются все исключения, поэтому запись в лог в своем коде не нужно оборачивать в try-catch.

[примеры](../examples/log/text_file/main.cc)  

### Структурированные логи

Формат - TSKV. Промежуточного представления данных нет, все атрибуты переводятся в строковое представление (с экранированием символов).

Можно записывать в лог:
- атрибуты по отдельности через make_attr
- множество атрибутов, сохраненных в map

При отправке в логброкер допустимо, если отсутствуют некоторые атрибуты.

[примеры](../examples/log/tskv/main.cc)  


### Общие рекомендации

По возможности предпочитайте использовать локальные логеры. Наиболее используемые уровни логирования: error, warning, info, debug.

Используйте info для обычных логов, как правило в продакшене debug логи отключены.

Не пишите в error то, что не является ошибкой для конкретного приложения. Например, разрыв соединения или некорректный параметр запроса в HTTP сервере - не ошибка для типичного сервера.
