## yplatform::task_context

Любой сервис выполняет какие-то задачи. Это может быть как внешний запрос, так и инициированная изнутри операция.

С задачей связан контекст ее выполнения, унаследованный от класса `task_context`. Этот базовый класс:

- генерирует при создании и отдает по запросу uniq_id - уникальный идентификатор задачи (сессии). Этот идентификатор обычно пишется в логи, чтобы провязывать по нему все записи, относящиеся к одной задаче;
- хранит идентификатор исходного пользовательского запроса, если задача заключается в обработке такового;
- поддерживает интерфейс хранения в контексте именованных структур, отнаследованных от `module_task_context`;
- поддерживает интерфейс для возврата статистики в ptree;
- содержит флаг `cancelled`, который сигнализирует о том, что задача отменена (см. подробнее ниже).

Обычно контекст передается между модулями как `shared_ptr<context>`.

### Уникальный идентификатор
Нужен для удобного поиска в логе всех записей о задаче, содержит буквы и цифры, условно уникален в рамках всего кластера, возможны редкие пересечения.

### Идентификатор запроса (`request_id`)
Назначение данного поля — возможность прокидывания идентификатора запроса по цепочке обрабатывающих этот запрос сервисов и записи его значения в логи каждого из этих сервисов с целью их увязывания между собой.

Как можно увидеть из функционала других модулей, реализация прокидывания включает следующие части:
- `ymod_webserver` заполняет поле `request_id` значением заголовка `X-Request-Id` из входящего запроса;
- `ymod_httpclient`, напротив, заполняет заголовок `X-Request-Id` значением поля `request_id` перед отправкой исходящего запроса.

### Хранение именованных структур
Нужно для хранения данных модуля внутри задачи и избавляет пользователя от необходимости хранить и передавать модулю данные, которые по сути являются его внутренними деталями. Например, POP3-клиент таким образом хранит сессию к удаленному серверу.

### Возврат статистики
Нужно для мониторинга. Отдается уникальный идентификатор, а также все то, что отнаследованный контекст туда поместит, перегрузив виртуальную функцию `get_stats()`.

### Флаг сancelled
Нужно для корректной внеплановой остановки задачи: например в случае со сборщиком сессию сбора можно прервать собрав не 10, а 5 новых сообщений - остальные будут дозагружены в рамках следующей сессии. При завершении сервиса `cancelled` проставляется всем задачам, зарегистрированным в [репозитории контекстов](../../yplatform/doc/guide/app_resources.md#репозиторий-контекстов).

### Deadline propagation
В контексте можно хранить дедлайн задачи. По истечению дедлайна задача считается остановленной. Различные модули платформы поддерживают работу с дедлайном (см. [deadline propagation](deadline_propagation.md)).
