#include <yplatform/module.h>
#include <yplatform/time_traits.h>

namespace time_traits = yplatform::time_traits;

class my_module : public yplatform::module
{
public:
    void init(const yplatform::ptree& conf)
    {
        flag_ = conf.get<bool>("flag"); // accepted values: yes/no, on/off, 1/0, true/false
        value_ = conf.get("value", 5);  // with default
        timeout_ = conf.get<time_traits::duration>("timeout"); // float seconds, i.e. "3.1"
    }

private:
    bool flag_;
    int value_;
    time_traits::duration timeout_;
};
