#include <yplatform/coroutine.h>
#include <boost/asio/io_service.hpp>
#include <iostream>
#include <string>

#include <yplatform/yield.h>

using yplatform::spawn;
using yplatform::yield_context;
using namespace std;

struct coro
{
    std::vector<int> ints;
    string text;

    void operator()(yield_context<coro> ctx)
    {
        reenter(ctx)
        {
            yield ctx();
            cout << text << endl;
        }
    }
};

int main()
{
    boost::asio::io_service io;
    spawn(io.get_executor(), coro{ { 1, 2, 3 }, "Hello, World!" });
    io.run();
    return 0;
}
