#include <yplatform/coroutine.h>
#include <yplatform/yield.h>
#include <iostream>

template <typename H>
void async_operation(H h)
{
    h("test", 5);
}

struct coro
{
    typedef yplatform::yield_context<coro> yield_context;

    std::string value;
    int x;

    void operator()(yield_context yield_ctx)
    {
        reenter(yield_ctx)
        {
            yield async_operation(yield_ctx.capture(value, x));
            std::cout << value << " " << x << std::endl;
        }
    }
};

int main()
{
    yplatform::spawn(coro());
    return 0;
}