#include <yplatform/coroutine.h>
#include <yplatform/yield.h>
#include <iostream>

template <typename H>
void async_operation(H h)
{
    throw std::runtime_error("async start failed");
    h();
}

struct coro
{
    using yield_context = yplatform::yield_context<coro>;

    std::function<void(bool)> handler;

    void operator()(yield_context yield_ctx)
    {
        reenter(yield_ctx)
        {
            yield async_operation(yield_ctx);
            handler(true);
        }
    }

    void operator()(yield_context::exception_type exception)
    {
        try
        {
            std::rethrow_exception(exception);
        }
        catch (const std::exception& e)
        {
            std::cout << "exception: \"" << e.what() << "\"\n";
        }
        handler(false);
    }
};

int main()
{
    auto handler = [](auto complete) { std::cout << (complete ? "success" : "fail") << std::endl; };
    boost::asio::io_service io;
    yplatform::spawn(io, coro{ handler });
    io.run();
    return 0;
}