#include <ymod_httpclient/client.h>
#include <yplatform/find.h>
#include <boost/property_tree/json_parser.hpp>

struct currency_service
{
    using handler_type = std::function<void(boost::system::error_code err, double rate)>;

    virtual void get_eur_to_usd_rate(
        yplatform::task_context_ptr context,
        const handler_type& handler) = 0;
    virtual ~currency_service() = default;
};

class currency_service_impl
    : public currency_service
    , public yplatform::module
{
public:
    currency_service_impl(boost::asio::io_service& io, const std::string& url)
        : http_client_(io), url_(url)
    {
    }

    void get_eur_to_usd_rate(yplatform::task_context_ptr context, const handler_type& handler)
        override
    {
        auto request = yhttp::request::GET(url_ + "?q=EUR_USD&compact=ultra");
        http_client_.async_run(
            context, request, [handler](boost::system::error_code err, yhttp::response response) {
                if (err)
                {
                    return handler(err, 0.0);
                }
                std::stringbuf buf(response.body);
                std::istream stream(&buf);
                yplatform::ptree resp;
                boost::property_tree::read_json(stream, resp);
                handler(boost::system::error_code(), resp.get<double>("EUR_USD"));
            });
    }

private:
    yhttp::client http_client_;
    std::string url_;
};
