#include "currency_service.h"

int main()
{
    boost::asio::io_service io;
    yplatform::log::init_console(io);
    // register module in io_service
    yplatform::register_module(
        io,
        "currency_service",
        std::make_shared<currency_service_impl>(
            io, "http://free.currencyconverterapi.com/api/v5/convert"));
    // access module through find function
    yplatform::find<currency_service>(io, "currency_service")
        ->get_eur_to_usd_rate(
            boost::make_shared<yplatform::task_context>(),
            [logger =
                 yplatform::log::find(io, "global")](boost::system::error_code err, double rate) {
                if (err)
                {
                    YLOG(logger, error) << "get exchange rate error: " << err.message();
                }
                else
                {
                    YLOG(logger, info) << "EUR to USD exchange rate is " << rate;
                }
            });
    io.run();
    return 0;
}
