#include <yplatform/log.h>
#include <yplatform/task_context.h>

namespace log = yplatform::log;

struct complex_operation : public log::contains_logger
{
public:
    void operator()(yplatform::task_context_ptr ctx)
    {
        YLOG_L(info) << "operation-local";
        YLOG_G(info) << "operation-global";
        YLOG_CTX_LOCAL(ctx, info) << "operation-local with task context";
        YLOG_CTX_GLOBAL(ctx, info) << "operation-global with task context";
    }
};

int main()
{
    // init custom log service within io_service
    boost::asio::io_service io;
    log::init_file(io, "file.log");
    auto logger = log::find(io, "global");
    YLOG(logger, info) << "test YLOG";

    // init as global
    log::init_global_log_file("file.log");
    L_(info) << "test L_";

    // local loggers
    auto local_logger = log::source(YGLOBAL_LOGGER);
    local_logger.set_log_prefix("http");
    complex_operation operation;
    operation.logger(local_logger);
    operation(boost::make_shared<yplatform::task_context>());

    return 0;
}
