#include <yplatform/log.h>

namespace log = yplatform::log;

int main()
{
    boost::asio::io_service io;
    log::settings settings;
    log::sink_settings sink;
    sink.type = log::sink_type::file;
    sink.path = "access.log";
    settings.logs["access_log"].sinks.emplace_back(sink);
    settings.logs["access_log"].format = "tskv\ttskv_format=my-service-access-log\ttimestamp=%Y-%m-"
                                         "%d %H:%M:%S.%f\ttimezone=+0300\t%v";
    log::init(io, settings);
    auto logger = log::find<log::tskv_logger>(io, "access_log");

    namespace typed = log::typed;
    YLOG(logger, info) << typed::make_attr("key", "value");
    typed::attributes_map attributes;
    attributes << typed::make_attr("key2", "value2");
    YLOG(logger, info) << attributes;

    return 0;
}
