#include <string>
#include <yplatform/net/server.h>
#include <boost/shared_array.hpp>
#include <boost/asio/coroutine.hpp>
#include <boost/asio/yield.hpp>

using yplatform::net::io_data;
using yplatform::net::unix_socket;
using yplatform::net::unix_socket_server;
using yplatform::net::tcp_socket;
using yplatform::net::tcp_server;
using error_code_t = boost::system::error_code;
using std::string;

template <typename Socket>
class session : public boost::asio::coroutine
{
public:
    session(Socket&& socket)
        : socket(std::make_shared<Socket>(std::move(socket))), buf(new char[256])
    {
    }

    void operator()(const error_code_t& err = error_code_t(), size_t bytes = 0)
    {
        reenter(this)
        {
            for (;;)
            {
                yield socket->async_read(
                    boost::asio::buffer(buf.get(), 256), yplatform::time_traits::seconds(2), *this);
                if (err) yield break;
                yield socket->async_write(
                    boost::asio::buffer(buf.get(), bytes),
                    yplatform::time_traits::seconds(2),
                    *this);
                if (err) yield break;
            }
        }
    }

private:
    std::shared_ptr<Socket> socket;
    boost::shared_array<char> buf;
};

int main()
{
    boost::asio::io_service io;
    io_data iodata(io);

    unix_socket_server server1(iodata, "/tmp/echo");
    server1.listen([](unix_socket&& socket) { session<unix_socket>(std::move(socket))(); });

    tcp_server server2(iodata, "::", 8080);
    server2.listen([](tcp_socket&& socket) { session<tcp_socket>(std::move(socket))(); });

    io.run();
    return 0;
}
