#include <string>
#include <ymod_tvm/module.h>
#include <yplatform/module.h>
#include <yplatform/application/global_init.h>
#include <yplatform/find.h>
#include <yplatform/loader.h>
#include <thread>
#include <fstream>

using std::string;

string CONFIG =
    R"(
config:
    system:
        libpath: [ 'lib64/modules' ]
    log:
    modules:
        module:
        -   system:
                name: http_client
                factory: yhttp::call_impl
            configuration:
                reactor: global
        -   system:
                name: tvm
                factory: ymod_tvm::tvm2::impl
            configuration:
                service_id: 2000197
                target_services:
                -   id: 2000198
                    name: proxy
                tvm_host: tvm-api.yandex.net
                tvm_secret_file: /tmp/test_tvm_secret
                keys_update_interval: 24:00:00
                tickets_update_interval: 01:00:00
                retry_interval: 00:10:00
                reactor: global
)";

class module_using_tvm : public yplatform::module
{
public:
    void init(const yplatform::ptree& conf)
    {
        auto tvm_name = conf.get("tvm", "tvm");
        using yplatform::find;
        auto tvm2 = find<ymod_tvm::tvm2_module, std::shared_ptr>(tvm_name);

        tvm2->subscribe_service_ticket(
            "proxy",
            [](const ymod_tvm::error_code& error, const string& service, const string& ticket) {
                if (error)
                {
                    YLOG_G(error) << "tvm2 error: " << error.message();
                    return;
                }
                YLOG_G(error) << "tvm2 '" << service << "' ticket: " << ticket;
            });
    }
};

int main()
{
    std::ofstream of("/tmp/test_tvm_secret");
    of << "esbNM_UIxZIDW5c4ND5zeg";
    of.close();

    yplatform::configuration conf;
    conf.load_from_str(CONFIG);
    yplatform::log::init_global_log(conf);
    yplatform::init_global_reactors(conf);
    yplatform::init_global_repository(conf);

    auto reactor = yplatform::global_net_reactor;
    {
        module_using_tvm nodule;
        nodule.init(yplatform::ptree());
        yplatform::repository::instance().start();
        reactor->run();
        std::this_thread::sleep_for(std::chrono::milliseconds(800));
        yplatform::repository::instance().stop();
        reactor->stop();
        yplatform::repository::instance().fini();
        reactor->fini();
    }

    return 0;
}
